; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their command detection.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10
;

[Command]
name = "hissatu"
command = z+c+a+b
time = 10

[Command]
name = "maggg"
command = a+b
time = 10

[Command]
name = "tobi5"
command = x+y
time = 10

[Command]
name = "hou"
command = z+c
time = 10

[Command]
name = "tobi9"
command = D,y
time = 20

[Command]
name = "tobi6"
command = D,x
time = 20

[Command]
name = "tobi7"
command = D,c
time = 20

[Command]
name = "tobi8"
command = D,z
time = 20

[Command]
name = "sb"
command = F,b
time = 10

[Command]
name = "tobi1"
command = c
time = 1

[Command]
name = "tobi2"
command = x
time = 1

[Command]
name = "tobi3"
command = y
time = 1

[Command]
name = "tobi4"
command = z
time = 1



;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = x+y
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "start"
command = s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;===========================================================================
;---------------------------------------------------------------------------
;Run Fwd
;_bV
[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Run Back
;ރ_bV
[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;
;
[State -1, Standing Strong Kick]
type = ChangeState
value = 789
triggerall = command = "hou"
triggerall = command != "holddown"
triggerall = numhelper(20002) <= 2
triggerall = numhelper(20020) = 0
triggerall = numhelper(20030) = 0
triggerall = numhelper(20040) = 0
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5
trigger3 = (stateno = 230) && time > 6

;---------------------------------------------------------------------------
;KEU
[State -1, Stand Light Punch]
type = ChangeState
value = 9999
triggerall = Var(40) = 0
triggerall = Power >= 10000
triggerall = numhelper(10010) = 0
triggerall = numhelper(10011) = 0
triggerall = numhelper(10012) = 0
triggerall = numhelper(10013) = 0
triggerall = numhelper(10014) = 0
triggerall = command = "hissatu"
trigger1 = statetype = S
trigger1 = statetype != A
trigger1 = ctrl


;---------------------------------------------------------------------------
;Super3300
[State Super 3300]
type = ChangeState
triggerall = Ctrl
triggerall = numhelper(10010) = 0
triggerall = numhelper(10011) = 0
triggerall = numhelper(10012) = 0
triggerall = numhelper(10013) = 0
triggerall = numhelper(10014) = 0
triggerall = StateType != A
trigger1 = statetype = S
triggerall = !Var(5)
triggerall = Power >= 3000
trigger1 = !Var(59)
triggerall = Var(45) = 0
trigger1 = Command = "maggg"
value = 3300
ctrl = 0

;---------------------------------------------------------------------------
;o[Y6
[State -1, Stand Light Punch]
type = ChangeState
value = 7005
triggerall = Var(40) = 0
;triggerall = numhelper(10010) = 0
triggerall = numhelper(10011) = 0
triggerall = numhelper(10012) = 0
triggerall = numhelper(10013) = 0
triggerall = numhelper(10014) = 0
triggerall = command = "tobi6"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;o[Y7
[State -1, Stand Light Punch]
type = ChangeState
value = 7006
triggerall = Var(40) = 0
;triggerall = numhelper(10010) = 0
triggerall = numhelper(10011) = 0
triggerall = numhelper(10012) = 0
triggerall = numhelper(10013) = 0
triggerall = numhelper(10014) = 0
triggerall = command = "tobi7"
trigger1 = statetype = S
trigger1 = ctrl


;---------------------------------------------------------------------------
;o[Y8
[State -1, Stand Light Punch]
type = ChangeState
value = 7007
triggerall = Var(40) = 0
;triggerall = numhelper(10010) = 0
triggerall = numhelper(10011) = 0
triggerall = numhelper(10012) = 0
triggerall = numhelper(10013) = 0
triggerall = numhelper(10014) = 0
triggerall = command = "tobi8"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;o[Y9
[State -1, Stand Light Punch]
type = ChangeState
value = 7008
triggerall = Var(40) = 0
;triggerall = numhelper(10010) = 0
triggerall = numhelper(10011) = 0
triggerall = numhelper(10012) = 0
triggerall = numhelper(10013) = 0
triggerall = numhelper(10014) = 0
triggerall = command = "tobi9"
trigger1 = statetype = S
trigger1 = ctrl


;---------------------------------------------------------------------------
;o[Y5
[State -1, Stand Light Punch]
type = ChangeState
value = 7004
triggerall = Var(40) = 0
;triggerall = numhelper(10010) = 0
triggerall = numhelper(10011) = 0
triggerall = numhelper(10012) = 0
triggerall = numhelper(10013) = 0
triggerall = numhelper(10014) = 0
triggerall = command = "tobi5"
trigger1 = statetype = S
trigger1 = ctrl


;---------------------------------------------------------------------------
;o[YтP
[State -1, Stand Light Punch]
type = ChangeState
value = 7000
triggerall = Var(40) = 0
triggerall = Power >= 500
triggerall = numhelper(10010) = 0
triggerall = numhelper(10011) = 0
triggerall = numhelper(10012) = 0
triggerall = numhelper(10013) = 0
;triggerall = numhelper(10014) = 0
triggerall = command = "tobi1"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;o[Y2
[State -1, Stand Light Punch]
type = ChangeState
value = 7001
triggerall = Var(40) = 0
triggerall = numhelper(10010) = 0
triggerall = numhelper(10011) = 0
triggerall = numhelper(10012) = 0
triggerall = numhelper(10013) = 0
triggerall = numhelper(10014) = 0
triggerall = command = "tobi2"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;o[Y3
[State -1, Stand Light Punch]
type = ChangeState
value = 7002
triggerall = Var(40) = 0
triggerall = numhelper(10010) = 0
triggerall = numhelper(10011) = 0
triggerall = numhelper(10012) = 0
triggerall = numhelper(10013) = 0
triggerall = numhelper(10014) = 0
triggerall = command = "tobi3"
trigger1 = statetype = S
trigger1 = ctrl


;---------------------------------------------------------------------------
;o[Y4
[State -1, Stand Light Punch]
type = ChangeState
value = 7003
triggerall = Var(40) = 0
triggerall = numhelper(10010) = 0
triggerall = numhelper(10011) = 0
triggerall = numhelper(10012) = 0
triggerall = numhelper(10013) = 0
triggerall = numhelper(10014) = 0
triggerall = command = "tobi4"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Standing Strong Kick
;X^hON
[State -1, Standing Strong Kick]
type = ChangeState
value = 600
triggerall = command = "a"
triggerall = command != "holddown"
triggerall = Var(40) = 0
triggerall = numhelper(6000) = 0
triggerall = numhelper(10010) = 0
triggerall = numhelper(10011) = 0
triggerall = numhelper(10012) = 0
triggerall = numhelper(10013) = 0
triggerall = numhelper(10014) = 0
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Standing Strong Kick
;X^hOFF
[State -1, Standing Strong Kick]
type = ChangeState
value = 601
triggerall = command = "a"
triggerall = command != "holddown"
triggerall = Var(40) = 1
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Standing Strong Kick
;LbN
[State -1, Standing Strong Kick]
type = ChangeState
value = 240
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5
trigger3 = (stateno = 230) && time > 6

;---------------------------------------------------------------------------
;Standing Strong Kick
;LbN
[State -1, Standing Strong Kick]
type = ChangeState
value = 241
triggerall = command = "sb"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5
trigger3 = (stateno = 230) && time > 6

;---------------------------------------------------------------------------
;Taunt
;
[State -1, Taunt]
type = ChangeState
value = 195
triggerall = command = "start"
trigger1 = statetype != A
trigger1 = ctrl



;---------------------------------------------------------------------------
;Jump Light Kick
[State -1, Jump Light Kick]
type = ChangeState
value = 630
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl


